-- ADM-160B MALD by Currenthill

  MIG29MU2_ADM160B_warhead = {
    mass                 = 0.0001, 
    caliber              = 70,
    expl_mass            = 0.0001, 
    piercing_mass        = 0.0001, 
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 1.0, 1.0, 1.0 },
    concrete_obj_factor  = 0.0,
    obj_factors          = { 1.0, 1.0 },
    cumulative_factor    = 0.0,
    cumulative_thickness = 0.0,
}

MIG29MU2_ADM_160_B =
{
	category		= CAT_MISSILES,
	name			= "MiG-29MU2_ADM_160B",
	user_name		= _("ADM-160B"),
    class_name      = "wAmmunitionCruise",
    scheme          = "sat_cruise_missile",
	model			= "MiG-29MU2_ADM-160B",
	mass			= 150,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {5, 5, 5},
	M				= 150.0,
	H_max			= 12500.0,
	H_min			= -1,
	Diam			= 250.0,
	Cx_pil			= 1,
	D_max			= 800000.0,
	D_min			= 5000.0,
	Head_Form		= 0,
	Life_Time		= 100000,
	Nr_max			= 6,
	v_min			= 80.0,
	v_mid			= 200.0,
	Mach_max		= 0.95,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 800000.0,
	H_min_t			= 0.0,
	Fi_start		= 1.0,
	Fi_rak			= 3.14152,
	Fi_excort		= 1.0,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 100.0,
	KillDistance	= 0.0,
	add_attributes = {"Cruise missiles"},	

	warhead		= MIG29MU2_ADM160B_warhead,
	warhead_air	= MIG29MU2_ADM160B_warhead,
	
	shape_table_data =
	{
		{
			name		= "MiG-29MU2_ADM_160B",
			file		= "MiG-29MU2_ADM-160B",
			life		= 1,
			fire		= { 0, 1},
			username	= _("ADM-160B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1950,  
		caliber     = 0.697,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.6,
		I           = 1 / 12 * 2050.0 * 6.6 * 6.6,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.7,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},
	
	seeker = {
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 6000,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
		
		inertial_km_error		= 4,		-- m for 1000m dist
		glide_height_eq_error	= 10,		-- percent
		glide_height_abs_error	= 1,
		stab_vel_abs_error		= 10.0,	
	},

	final_autopilot =		{
		delay				= 0,
		K					= 70,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 0,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	control_block ={
		seeker_activation_dist		= 15000,
		default_cruise_height		= 6000,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},
	
	controller = {
		boost_start	= 0.001,
		march_start = 0.8,
	},
	

	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	
	march = {
		impulse			= 690,
		fuel_mass		= 1283.5,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-1.4, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.3,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.002,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 0,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},		
	},
	
	play_booster_animation = {
		val = 0,
	},
			
}


declare_weapon(MIG29MU2_ADM_160_B)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{MiG-29MU2_ADM-160B}",
	attribute		= MIG29MU2_ADM_160_B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.001953125,
	Picture			= "MIG29MU2_ADM160B.png",
	displayName		= _("ADM-160B MALD - Miniature Air-Launched Decoy"),
	Weight			= MIG29MU2_ADM_160_B.mass,
	Elements  		= {{ShapeName = "MiG-29MU2_ADM-160B"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{MiG-29MU2_ADM-160B_LAU118}",
	attribute		= MIG29MU2_ADM_160_B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.001953125,
	Picture			= "MIG29MU2_ADM160B.png",
	displayName		= _("ADM-160B MALD - Miniature Air-Launched Decoy"),
	Weight			= MIG29MU2_ADM_160_B.mass,
	-- Elements  		= {{ShapeName = "MiG-29MU2_ADM-160B"}},
	wsTypeOfWeapon		= MIG29MU2_ADM_160_B.wsTypeOfWeapon,	
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},	
	Elements			=	
	{
		{	ShapeName	=	"lau-118a"	   	  ,	IsAdapter  	   =   true  }, 
		{	payload_CLSID =	 "{MiG-29MU2_ADM-160B}",	connector_name =  "Point01"},
	}-- end of Elements
})

declare_loadout({
	category 			= CAT_MISSILES,
	CLSID	 			= "{MIG29MU2_BRU_42A_x3_ADM_160B}",
	Picture				= "MIG29MU2_ADM160B.png",
	Cx_pil				= 0.00244140625 + 3*0.001953125,
	displayName			= _("ADM-160B MALD x 3 - Miniature Air-Launched Decoy"),
	Count				= 3,
	Weight				= 50.80 + 3 * MIG29MU2_ADM_160_B.mass,
	wsTypeOfWeapon		= MIG29MU2_ADM_160_B.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	Elements			=	
		{
			{	ShapeName	=	"BRU_42A"	   	  ,	IsAdapter  	   =   true  }, 
			{	payload_CLSID =	 "{MiG-29MU2_ADM-160B}",	connector_name =  "Point01"},
			{	payload_CLSID =	 "{MiG-29MU2_ADM-160B}",	connector_name =  "Point02"},
			{	payload_CLSID =	 "{MiG-29MU2_ADM-160B}",	connector_name =  "Point03"},
		}-- end of Elements
})
